# Intructions

## Python Environment Setup:
The code uses the following key packages: `cvxpy (1.1.15)`, `numpy (1.23.2)`, `sklearn (1.1.2)`, `gurobi for Python (9.5.2)`. You may also directly install them using the following command:

> pip install -r requirements.txt

For the `influence` attack environment setup, please refer to the README file in the `influence_attack/influence` folder. Once the python environment is setup, follow the instructions below to produce the results presented in the paper. Due to size limit for supplemenraty meterials, we
provide the datasets used in this paper in an anonymous [link](https://drive.google.com/file/d/1S7ukzy2MUxZ6TAv2DP3ImqUbBYhWofEy/view?usp=share_link). Download the datasets and place in them proper places and update the `DATA_FOLDER` in `datasets.py`, `data_utils.py` and `influence_attack/datasets.py` accordingly.  

## Run the Attack
The commands below will generate attack results for Figure 1, Table 1 in the main paper and Table 4 in the Appendix (complements the last paragraph in the Discussion section in the paper).

To get the performance of current attacks, run the following commands in order. Model-targeted, Min-Max and KKT attacks all require target models and hence, you will need to first generate the target models.

###  Generate the target models

we use MNIST 1-7 as an example below and other datasets can be specified by setting `--dataset` as `mnist_49`, `mnist_69`, `adult`, `enron`, `filtered_enron`, `dogfish`, `cifar10_89` (preliminary results of Figure 2 in the paper). The generated target models will be saved upon completion:

> python generate_theta.py --dataset mnist_17

### Run the attack

We use the Min-Max attack on MNIST 1-7 as an example. By default, all attacks run for 3% of poisoning ratio, but can change the ratio by setting `--epsilon` accordingly. Other attacks can be specified by setting ``--attack`` as ``kkt, mta`` or `all` to run all attacks at once. To obtain the attack performance with data sanitization defense (see last paragraph in the Discussion section and Table 4 in the Appendix), add `--use_slab` and `--use_sphere`. The victim model is by default linear SVM, but can be changed to logistic regression with `--model_type lr`. Once the attacks are completed, the attack results will be saved:

> python run_attack.py --dataset mnist_17 --attack min_max

The ``influence`` attack requires GPU computation and is handled separately in a separate folder `influence_attack` (adapted from the original repository with slight modification), so to obtain its attack results, run the following command instead:

>python run_gradient_em_attack.py --em_iter 0 --total_grad_iter 10000 --dataset mnist_17 --fixed_eps 

Once all the attacks are finished, you can either record the results in your preferred way or run the following command to
obtain a summary statistics of the attacks of your interest

> python process_attack_results.py --dataset mnist_17 --attack all

## Compute the Metrics
The command below generates the metric results for Table 1 and Table 4 in the paper. We use MNIST 1-7 as an example and the key metrics can be collected upon completion (remove `--filter_points` if to compute the metrics on the whole test data):

> compute_metrics.py --dataset mnist_17 --filter_points





